local sound = ui.MediaPlayer()
local sound1 = ui.MediaPlayer()
local rpmCheck = ui.MediaPlayer()
local turnSignal = ui.MediaPlayer()
local modeSound = ui.MediaPlayer()

sound:setSource('./engine.mp3')
sound1:setSource('./sounds/chime.mp3')
rpmCheck:setSource('./sounds/chime.mp3')
turnSignal:setSource('./sounds/turn_signals.mp3')

sound:setLooping(false)
sound1:setLooping(false)
rpmCheck:setLooping(false)
turnSignal:setLooping(false)
modeSound:setLooping(false)

-- State
local prev_extraA = false
local prev_extraF = false
local prev_extraC = false

local engineOn = false
local ecuLimiterActive = false
local rpmPlayed = false
local oilTempPlayed = false

function script.update(dt)
  local carState = ac.getCar()
  local volumeMain = ac.getAudioVolume('main')

  -- Engine start prompt
  if not engineOn then
    ac.setMessage("🟡 Press Extra A to Start Engine")
  end

  -- Extra A: Engine Toggle
  if car.extraA and not prev_extraA then
    engineOn = not engineOn
    if engineOn then
      ac.setMessage("✅ Engine Started")
      sound:play()
      sound:setVolume(volumeMain * 0.7)
    else
      ac.setMessage("🛑 Engine Off\n🟡 Press Extra A to Start")
    end
  end
  prev_extraA = car.extraA

  if not engineOn then return end


  -- RPM Warning
  if carState.rpm <= 7290 and ac.isInteriorView() then
    if not rpmPlayed then
      rpmCheck:play()
      rpmCheck:setVolume(volumeMain * 0.2)
      rpmPlayed = true
    end
  else
    rpmPlayed = false
  end

  -- Oil Temp Warning
  if carState.oilTemperature > 190 and ac.isInteriorView() then
    if not oilTempPlayed then
      sound1:play()
      sound1:setVolume(volumeMain * 0.2)
      oilTempPlayed = true
    end
  else
    oilTempPlayed = false
  end

  -- Debug log
  ac.log("Oil Temp: " .. tostring(carState.oilTemperature))
end



  local carState = ac.getCar()
  local volumeMain = ac.getAudioVolume('main')

  -- Engine start prompt
  if not engineOn then
    ac.setMessage("🟡 Press Extra A to Start Engine")
  end

  -- Extra A: Engine Toggle
  if car.extraA and not prev_extraA then
    engineOn = not engineOn
    if engineOn then
      ac.setMessage("✅ Engine Started")
      sound:play()
      sound:setVolume(volumeMain * 0.7)
    else
      ac.setMessage("🛑 Engine Off\n🟡 Press Extra A to Start")
    end
  end
  prev_extraA = car.extraA

  if not engineOn then return end

  -- Extra F: Toggle Fuel Modes
  if car.extraF and not prev_extraF then
    fuelMode = (fuelMode + 1) % 3

    if fuelMode == 1 then
      ac.setMessage("🏁 SPORT MODE\nThrottle Gain: 1.1")
      carPhysics.throttleGain = 1.1
    elseif fuelMode == 2 then
      ac.setMessage("🚀 PERFORMANCE MODE\nThrottle Gain: 1.25")
      carPhysics.throttleGain = 1.25
    else
      ac.setMessage("🔧 STOCK MODE\nThrottle Gain: 1.0")
      carPhysics.throttleGain = 1.0
    end

    modeSound:play()
    modeSound:setVolume(volumeMain * 0.4)
  end
  prev_extraF = car.extraF

  -- RPM Warning
  if carState.rpm <= 7290 and ac.isInteriorView() then
    if not rpmPlayed then
      rpmCheck:play()
      rpmCheck:setVolume(volumeMain * 0.2)
      rpmPlayed = true
    end
  else
    rpmPlayed = false
  end

  -- Oil Temp Warning
  if carState.oilTemperature > 190 and ac.isInteriorView() then
    if not oilTempPlayed then
      sound1:play()
      sound1:setVolume(volumeMain * 0.2)
      oilTempPlayed = true
    end
  else
    oilTempPlayed = false
end
-- Media Players
local sound = ui.MediaPlayer()
local sound1 = ui.MediaPlayer()
local rpmCheck = ui.MediaPlayer()
local turnSignal = ui.MediaPlayer()
local modeSound = ui.MediaPlayer()

sound:setSource('./engine.mp3')
sound1:setSource('./sounds/chime.mp3')
rpmCheck:setSource('./sounds/chime.mp3')
turnSignal:setSource('./sounds/turn_signals.mp3')

sound:setLooping(false)
sound1:setLooping(false)
rpmCheck:setLooping(false)
turnSignal:setLooping(false)
modeSound:setLooping(false)

-- State
local prev_extraA = false
local prev_extraF = false
local prev_extraC = false

local engineOn = false
local ecuLimiterActive = false
local rpmPlayed = false
local oilTempPlayed = false

function script.update(dt)
  local carState = ac.getCar()
  local volumeMain = ac.getAudioVolume('main')

  -- Engine start prompt
  if not engineOn then
    ac.setMessage("🟡 Press Extra A to Start Engine")
  end

  -- Extra A: Engine Toggle
  if car.extraA and not prev_extraA then
    engineOn = not engineOn
    if engineOn then
      ac.setMessage("✅ Engine Started")
      sound:play()
      sound:setVolume(volumeMain * 0.7)
    else
      ac.setMessage("🛑 Engine Off\n🟡 Press Extra A to Start")
    end
  end
  prev_extraA = car.extraA

  if not engineOn then return end


  -- RPM Warning
  if carState.rpm <= 7290 and ac.isInteriorView() then
    if not rpmPlayed then
      rpmCheck:play()
      rpmCheck:setVolume(volumeMain * 0.2)
      rpmPlayed = true
    end
  else
    rpmPlayed = false
  end

  -- Oil Temp Warning
  if carState.oilTemperature > 190 and ac.isInteriorView() then
    if not oilTempPlayed then
      sound1:play()
      sound1:setVolume(volumeMain * 0.2)
      oilTempPlayed = true
    end
  else
    oilTempPlayed = false
  end

  -- Debug log
  ac.log("Oil Temp: " .. tostring(carState.oilTemperature))
end
