local cluster = ac.newScriptableDisplay()

-- Load the image (make sure path is relative to the game root or UI folder)
local myImage = ac.loadImage('cluster/Chevrolet_CamaroZL11LE_2021_Interior_A_Screens_Emissive.dds')

-- Center of your display (adjust as needed)
local centerX = 640
local centerY = 360
local radius = 300

-- Color gradient for RPM bar
local colorLut = ac.Lut([[
  0    | 0, 1, 0
  0.5  | 1, 1, 0
  1    | 1, 0, 0
]], { 1 })

function cluster:draw(deltaTime)
    -- Draw background image
    self:drawImage(myImage, 0, 0, 1280, 720)

    -- Get RPM and speed
    local rpm = ac.getCarState(0, ac.CarState.RPM)
    local speed = ac.getCarState(0, ac.CarState.SpeedKMH)
    local rpmMax = 7000

    -- RPM color based on LUT
    local rpmRatio = math.min(rpm / rpmMax, 1.0)
    local output = {}
    colorLut:calculateTo(output, rpmRatio)
    local rpmColor = rgb(output[1] * 255, output[2] * 255, output[3] * 255)

    -- RPM bar
    self:drawArc(centerX - 250, centerY, radius, math.pi * 0.75, math.pi * (0.75 + 1.5 * rpmRatio), rpmColor, 15)

    -- Speed bar (static blue)
    local speedMax = 250
    local speedRatio = math.min(speed / speedMax, 1.0)
    self:drawArc(centerX + 250, centerY, radius, math.pi * 0.75, math.pi * (0.75 + 1.5 * speedRatio), rgb(0, 0, 255), 15)

    -- Text
    self:drawText(string.format("RPM: %d", rpm), centerX - 300, centerY + 200, 0.8)
    self:drawText(string.format("Speed: %d km/h", speed), centerX + 200, centerY + 200, 0.8)
end

return cluster
