local car
local Icons = {
  SPEEDLIMIT_OUT_PITS = "cluster/NO_LIMIT.png",
  IN_PITS = "cluster/NO_LIMIT_2.png"
}

local sound = ui.MediaPlayer()
sound:setSource('cluster/audiomass-output.mp3')
sound:setVolume(ac.getAudioVolume('main') * 0.55)
sound:setLooping(false)
local flag = 0


local uv_top_left     = vec2(0,   0.5)
local uv_top_right    = vec2(1,   0.9)
local uv_bottom_left  = vec2(0,   0)
local uv_bottom_right = vec2(1,   0.0)

function script.update(dt)
  car = ac.getCar(0)

--Pit Limiter sound--

  local speed = car.speedKmh
  local interior = ac.isInteriorView()

if speed > 240 then
    flag = 0
  elseif speed > 120 then
    if interior then
      sound:play()
      flag = 1
  else
    flag = 0
    flag = 0
  end
local inPitlane = car.isInPitlane
local inPit     = car.isInPit

  if inPitlane or inPit then
    ui.drawImage(Icons.IN_PITS, vec2(290, 425), vec2(385,460), rgbm(1,1,1,1), uv_bottom_left, uv_top_right)
  elseif not inPitlane and speed < 120 then
    ui.drawImage(Icons.SPEEDLIMIT_120_PITS, vec2(290, 425), vec2(385,460), rgbm(1,1,1,1), uv_bottom_left, uv_top_right)
    elseif speed > 120 then
      ui.drawImage(Icons.SPEEDLIMIT_OUT_PITS, vec2(290, 425), vec2(385,460), rgbm(1,1,1,1), uv_bottom_left, uv_top_right)
    end
  end
ac.debug(("Speed: %.1f km/h"):format(car.speedKmh))
  ac.debug("inPitlane: "..tostring(inPitlane))
  ac.debug("inPit: "..tostring(inPit))
  ac.debug(interior)
end