if car.isAIControlled then
  return nil
end

local engineCounter = 0 -- для логіки запуску/зупинки двигуна

--------------------------------------------
-- Налаштування
--------------------------------------------
local SETTINGS = {
  launchRpmLimit  = 4200,
  launchGas       = 0.35,
  turboExtra      = 2,
  gearFirst       = 2,
  gearThird       = 4,
  brakeThreshold  = 0.30,
  handbrakeThresh = 0.30,
  gasThreshold    = 0.90,
  messageTime     = 1.0   -- час показу сповіщень, сек
}

--------------------------------------------
-- Внутрішні змінні
--------------------------------------------
local originalFinalRatio  = nil
local originalRpmLimit    = nil
local originalGasOverride = math.huge
local inLaunchPrep        = false
local launchEngaged       = false
local engineRunning       = true  -- двигун увімкнений від старту

-- Менеджер сповіщень (щоб авто-ховати через 1с)
local msgTimer = 0

local function pushMessage(text, duration)
  ac.setMessage(text)
  msgTimer = duration or SETTINGS.messageTime
end

--------------------------------------------
-- Основна логіка
--------------------------------------------
function script.update(dt)
  local data = ac.accessCarPhysics()
  if not data then return end

  -- Тік таймера сповіщень + авто-очистка
  if msgTimer > 0 then
    msgTimer = msgTimer - dt
    if msgTimer <= 0 then
      ac.setMessage("") -- прибираємо сповіщення
      msgTimer = 0
    end
  end

  -- ============================
  -- Логіка запуску/зупинки двигуна
  -- ============================
  if car.extraD then
    -- ДВИГУН ВИМКНЕНО: показуємо сповіщення ОДИН РАЗ при переході в стан off
    if engineRunning then
      engineRunning = false
      engineCounter = 0
      pushMessage("Engine OFF", SETTINGS.messageTime)
    end
    data.rpm = 0
    engineCounter = 0
    return
  else
    -- ДВИГУН УВІМКНЕНО: показуємо сповіщення ОДИН РАЗ при переході в стан on
    if not engineRunning then
      engineRunning = true
      engineCounter = 0
      pushMessage("Engine ON", SETTINGS.messageTime)
    end

    if engineCounter < 1.35 then
      if engineCounter < 0.00001 then
        data.rpm = 1
      else
        data.gas = 0.045
      end
      engineCounter = engineCounter + dt
    end
  end

  -- ============================
  -- Launch Control
  -- ============================
  local gear      = data.gear
  local gas       = data.gas
  local brake     = data.brake
  local handbrake = data.handbrake
  local traction  = data.tractionControlMode

  if gear == SETTINGS.gearFirst
     and gas > SETTINGS.gasThreshold
     and brake > SETTINGS.brakeThreshold
     and handbrake > SETTINGS.handbrakeThresh
     and traction == 0
     and not inLaunchPrep 
     and not launchEngaged
     and engineRunning
  then
    inLaunchPrep  = true
    launchEngaged = false

    if originalFinalRatio == nil then
      originalFinalRatio = data.gearsFinalRatio
    end

    if originalRpmLimit == nil then
      originalRpmLimit = data.rpmLimit
    end

    ac.setGearsFinalRatio(0)
    local newBoost = ac.getCar(0).turboBoost + SETTINGS.turboExtra
    ac.overrideTurboBoost(-1, newBoost)
    ac.setEngineRPMLimit(SETTINGS.launchRpmLimit, false)
    ac.overrideGasInput(SETTINGS.launchGas)
  end

  if inLaunchPrep then
    if gas < SETTINGS.gasThreshold then
      revertAll()
    elseif brake < SETTINGS.brakeThreshold and handbrake < SETTINGS.handbrakeThresh then
      inLaunchPrep  = false
      launchEngaged = true

      if originalFinalRatio then
        ac.setGearsFinalRatio(originalFinalRatio)
      end

      if originalRpmLimit then
        ac.setEngineRPMLimit(originalRpmLimit, false)
      end

      ac.overrideGasInput(math.huge)
    end
  end

  if launchEngaged then
    local gearTooHigh  = (gear >= SETTINGS.gearThird)
    local gearTooLow   = (gear <= 0)
    local gasReleased  = (gas < SETTINGS.gasThreshold)
    local userBraking  = (brake > SETTINGS.brakeThreshold)

    if gearTooHigh or gearTooLow or gasReleased or userBraking then
      ac.overrideTurboBoost(-1, nil)
      launchEngaged = false
    end
  end
end

--------------------------------------------
-- Хелпер для скидання всіх налаштувань
--------------------------------------------
function revertAll()
  inLaunchPrep  = false
  launchEngaged = false

  if originalFinalRatio then
    ac.setGearsFinalRatio(originalFinalRatio)
  end

  if originalRpmLimit then
    ac.setEngineRPMLimit(originalRpmLimit, false)
  end

  ac.overrideGasInput(math.huge)
  ac.overrideTurboBoost(-1, nil)

  originalFinalRatio  = nil
  originalRpmLimit    = nil
  originalGasOverride = math.huge
end
