

function modeA(dt) 
    
	
    display.rect {
        color = rgbm(1,1,1,1),
        pos = vec2(0, 0), 
        size = vec2(1024, 1024)
    }
 
    display.image {
        image = "assets/Q.dds",
        pos = vec2(0, 0), 
        size = vec2(1024, 1024)
    }

    display.text {
        text = string.format("%3d", car.lapCount), 
        pos = vec2(750, 334),
        letter = vec2(20, 40),
        font = "e92_big",
        width = 46,
        alignment = 1,
        spacing = -15,
        color = rgbm(1,1,1,1)
    }
	 
	display.text {
        text = string.format("%3.1f", car.brakeBias), 
        pos = vec2(825, 625),
        letter = vec2(20, 40),
        font = "e92_big",
        width = 46,
        alignment = 1,
        spacing = -5,
        color = rgbm(1,1,1,1)
    }

    display.text {
        text = string.format("%3d", car.poweredWheelsSpeed), 
        pos = vec2(468, 328),
        letter = vec2(30, 60),
        font = "e92_big",
        width = 46,
        alignment = 0.5,
        spacing = -1,
        color = rgbm(1,1,1,1)
    }


    display.text {
        text = string.format("%.1f", car.performanceMeter),
        pos = vec2(730, 475),
        letter = vec2(35, 70),
        font = "e92_big",
        width = 46,
        alignment = 1,
        spacing = -3
    }
	
	    local time = car.lapTimeMs
    local formattedTime =
        string.format(
        "%01d:%02d:%02d",
        math.floor((time / (1000 * 60))) % 60,
        math.floor((time / 1000)) % 60,
        math.floor((time % 1000) / 100)
    )
	
    display.text {
        text = formattedTime,
        pos = vec2(148, 475),
        letter = vec2(35, 70),
        font = "e92_big",
        width = 46,
        alignment = 1,
        spacing = -3
    }
	
	
	display.text {
        text = string.format("%.1f", car.wheels[0].tyrePressure / 14.5),
        pos = vec2(435, 610),
        letter = vec2(20, 50),
        font = "e92_big",
        width = 1,
        alignment = 1,
        spacing = -6

    }

	display.text {
        text = string.format("%.1f", car.wheels[1].tyrePressure / 14.5),
        pos = vec2(540, 610),
        letter = vec2(20, 50),
        font = "e92_big",
        width = 1,
        alignment = 1,
        spacing = -6

    }
	
	display.text {
        text = string.format("%.1f", car.wheels[2].tyrePressure / 14.5),
        pos = vec2(435, 652),
        letter = vec2(20, 50),
        font = "e92_big",
        width = 1,
        alignment = 1,
        spacing = -6

    }
	
	display.text {
        text = string.format("%.1f", car.wheels[3].tyrePressure / 14.5),
        pos = vec2(540, 652),
        letter = vec2(20, 50),
        font = "e92_big",
        width = 1,
        alignment = 1,
        spacing = -6

    }
	
		display.text {
        text = string.format("%3d", car.absMode),
        pos = vec2(68, 385),
        letter = vec2(20, 50),
        font = "e92_big",
        width = 1,
        alignment = 1,
        spacing = -6

    }
	
	display.text {
        text = string.format("%3d", car.tractionControlMode),
        pos = vec2(60, 436),
        letter = vec2(20, 50),
        font = "e92_big",
        width = 1,
        alignment = 1,
        spacing = -1

    }

	display.text {
        text = string.format("%3d", sim.ambientTemperature),
        pos = vec2(60, 485),
        letter = vec2(20, 50),
        font = "e92_big",
        width = 1,
        alignment = 1,
        spacing = -1

    }
	
	
	display.text {
        text = string.format("%3d", car.distanceDrivenSessionKm),
        pos = vec2(60, 534),
        letter = vec2(20, 50),
        font = "e92_big",
        width = 1,
        alignment = 1,
        spacing = -1

    }

    if (car.fuel <= 10) then
       display.rect {
            pos = vec2(940, 386),
            size = vec2(60,60),
            color = red
        }       
		display.rect {
            pos = vec2(188, 195),
            size = vec2(60,60),
            color = red
        } 
		
	end

    local gearText = tostring(car.gear) -- needs to be converted so that neutral and reverse display correctly (-1 = R, 0 = N)
    if car.gear == -1 then
        gearText = "R"
    end
    if car.gear == 0 then
        gearText = "N"
    end

    display.text {
        text = gearText,
        pos = vec2(450, 320),
        letter = vec2(120, 300),
        font = "mp4_big",
        width = 46,
        alignment = 0.5,
        spacing = 0
    }
	
	end
	

function modeB(dt)


    display.rect {
        color = rgbm(1,1,1,1),
        pos = vec2(0, -1), 
        size = vec2(1024, 1024)
    }
    

    display.image {
        image = "assets/R1.dds",
        pos = vec2(0, 0), 
        size = vec2(1024, 1024)
    }  
	
    display.text {
        text = string.format("%3d", car.lapCount), 
        pos = vec2(750, 334),
        letter = vec2(20, 40),
        font = "e92_big",
        width = 46,
        alignment = 1,
        spacing = -15,
        color = rgbm(1,1,1,1)
    }
	 
	display.text {
        text = string.format("%3.1f", car.brakeBias), 
        pos = vec2(825, 625),
        letter = vec2(20, 40),
        font = "e92_big",
        width = 46,
        alignment = 1,
        spacing = -5,
        color = rgbm(1,1,1,1)
    }

    display.text {
        text = string.format("%3d", car.poweredWheelsSpeed), 
        pos = vec2(468, 328),
        letter = vec2(30, 60),
        font = "e92_big",
        width = 46,
        alignment = 0.5,
        spacing = -1,
        color = rgbm(1,1,1,1)
    }


    display.text {
        text = string.format("%3.1f", car.oilPressure), 
        pos = vec2(299, 530),
        letter = vec2(25, 50),
        font = "e92_big",
        width = 46,
        alignment = 1,
        spacing = -8,
        color = rgbm(1,1,1,1)
    }
	
    display.text {
        text = string.format("%1d", car.oilPressure), 
        pos = vec2(295, 435),
        letter = vec2(25, 50),
        font = "e92_big",
        width = 46,
        alignment = 1,
        spacing = -3,
        color = rgbm(1,1,1,1)
    }
	
	    display.text {
        text = string.format("%3d", car.oilTemperature), 
        pos = vec2(285, 388),
        letter = vec2(25, 50),
        font = "e92_big",
        width = 46,
        alignment = 1,
        spacing = -3,
        color = rgbm(1,1,1,1)
    }
    
    display.text {
        text = string.format("%3d", car.waterTemperature), 
        pos = vec2(285, 485),
        letter = vec2(25, 50),
        font = "e92_big",
        width = 46,
        alignment = 1,
        spacing = -3,
        color = rgbm(1,1,1,1)
    }

	display.text {
        text = string.format("%.1f", car.wheels[0].tyrePressure / 14.5),
        pos = vec2(435, 610),
        letter = vec2(20, 50),
        font = "e92_big",
        width = 1,
        alignment = 1,
        spacing = -6

    }

	display.text {
        text = string.format("%.1f", car.wheels[1].tyrePressure / 14.5),
        pos = vec2(540, 610),
        letter = vec2(20, 50),
        font = "e92_big",
        width = 1,
        alignment = 1,
        spacing = -6

    }
	
	display.text {
        text = string.format("%.1f", car.wheels[2].tyrePressure / 14.5),
        pos = vec2(435, 652),
        letter = vec2(20, 50),
        font = "e92_big",
        width = 1,
        alignment = 1,
        spacing = -6

    }
	
	display.text {
        text = string.format("%.1f", car.wheels[3].tyrePressure / 14.5),
        pos = vec2(540, 652),
        letter = vec2(20, 50),
        font = "e92_big",
        width = 1,
        alignment = 1,
        spacing = -6

    }
	
		display.text {
        text = string.format("%3d", car.absMode),
        pos = vec2(68, 385),
        letter = vec2(20, 50),
        font = "e92_big",
        width = 1,
        alignment = 1,
        spacing = -6

    }
	
	display.text {
        text = string.format("%3d", car.tractionControlMode),
        pos = vec2(60, 436),
        letter = vec2(20, 50),
        font = "e92_big",
        width = 1,
        alignment = 1,
        spacing = -1

    }

	display.text {
        text = string.format("%3d", sim.ambientTemperature),
        pos = vec2(60, 485),
        letter = vec2(20, 50),
        font = "e92_big",
        width = 1,
        alignment = 1,
        spacing = -1

    }
	
	
	display.text {
        text = string.format("%3d", car.distanceDrivenSessionKm),
        pos = vec2(60, 534),
        letter = vec2(20, 50),
        font = "e92_big",
        width = 1,
        alignment = 1,
        spacing = -1

    }

    display.text {
        text = string.format("%.1f", car.performanceMeter),
        pos = vec2(735, 520),
        letter = vec2(30, 60),
        font = "e92_big",
        width = 46,
        alignment = 1,
        spacing = -3
    }

    local time = car.lapTimeMs
    local formattedTime =
        string.format(
        "%01d:%02d:%02d",
        math.floor((time / (1000 * 60))) % 60,
        math.floor((time / 1000)) % 60,
        math.floor((time % 1000) / 100)
    )
	
    display.text {
        text = formattedTime,
        pos = vec2(663, 418),
        letter = vec2(35, 70),
        font = "e92_big",
        width = 46,
        alignment = 1,
        spacing = -3
    }

    
    local gearText = tostring(car.gear) -- needs to be converted so that neutral and reverse display correctly (-1 = R, 0 = N)
    if car.gear == -1 then
        gearText = "R"
    end
    if car.gear == 0 then
        gearText = "N"
    end
	
    display.text {
        text = gearText,
        pos = vec2(450, 320),
        letter = vec2(120, 300),
        font = "mp4_big",
        width = 46,
        alignment = 0.5,
        spacing = 0
    }

end



local listOfModes = {modeA, modeB} 
local currentMode = tonumber(ac.loadDisplayValue("displayMode", 1))
local lastExtraCState = false

function script.update(dt)
    ac.debug("Update Delta", dt)
    if car.extraC ~= lastExtraCState then 
        currentMode = currentMode + 1 
        if currentMode > #listOfModes then 
            currentMode = 1
        end
        ac.saveDisplayValue("displayMode", currentMode)
    end
    ac.debug("Current Page", currentMode)
    lastExtraCState = car.extraC
    listOfModes[currentMode](dt)
end



