

function DrawSongData(song)

    local minutes = math.floor(song.trackPosition / 60)
    local seconds = song.trackPosition % 60
    local songArtist = song.artist
    if string.len(songArtist) > 12 then
        songArtist = string.sub(songArtist, 1, 8) .. "..."
    end

    if song.title == '' then
        display.text({ 
            text = "No CD",
            pos = vec2(519, 435),
            letter = vec2(50, 75),
            font = "amg",
            color = rgbm.colors.white,
            alignment = 0,
            width = 10,
            spacing = -10
        })
        display.text({
            text = string.format("%02d:%02d", 0, 0),
            pos = vec2(1360, 435),
            letter = vec2(40, 50),
            font = "amg",
            color = rgbm.colors.white,
            alignment = 1,
            spacing = -18,
            width = 300
        })
        display.text({
            text = string.format("%s", "No Artist"),
            pos = vec2(515, 780),
            letter = vec2(70, 95),
            font = "amg",
            color = rgbm.colors.white,
            alignment = 1,
            width = 274,
            spacing = -19
        })
    else
        display.text({
            text = string.format("%d %s", song.trackNumber, song.title),
            pos = vec2(519, 435),
            letter = vec2(50, 75),
            font = "amg",
            color = rgbm.colors.white,
            alignment = 1,
            width = 274,
            spacing = -15
        })

        display.text({
            text = string.format("%02d:%02d", minutes, seconds),
            pos = vec2(1360, 435),
            letter = vec2(40, 50),
            font = "amg",
            color = rgbm.colors.white,
            alignment = 1,
            spacing = -18,
            width = 300
        })

        display.text({
            text = string.format("%s", songArtist),
            pos = vec2(515, 780),
            letter = vec2(70, 95),
            font = "amg",
            color = rgbm.colors.white,
            alignment = 1,
            width = 274,
            spacing = -19
        })
    end
end


function DrawSongProgress(song)
    if song.trackPosition ~= -1 then
        trackPosition = song.trackPosition
    else
        trackPosition = 0
    end

    if song.trackDuration ~= -1 then
        trackDuration = song.trackDuration
    else
        trackDuration = 180 -- avg song time is 3 min, serves as a fallback
    end

    display.horizontalBar({
        text = '',
        pos = vec2(528, 523),
        size = vec2(955, 19),
        delta = 0,
        activeColor = rgbm.colors.white,
        inactiveColor = rgbm.colors.transparent,
        total = trackDuration,
        active = math.min(trackPosition, trackDuration)
    })
end

function DrawTime()
    display.text({
        text = string.format("%02d:%02d", sim.timeHours, sim.timeMinutes),
        pos = vec2(230, 63),
        letter = vec2(65, 95),
        font = "amg2",
        color = rgbm.colors.yellow,
        alignment = 1,
        spacing = -27,
        width = 0
    })
end



function script.update(dt)
    local song = ac.currentlyPlaying()
    DrawTime()
    DrawSongData(song)
    DrawSongProgress(song)
end