local gearposmap = {
    [-1] = vec2(0, 0),
    [0] = vec2(0, 0),
    [1] = vec2(176, 650),
    [2] = vec2(250, 650),
    [3] = vec2(332, 650),
    [4] = vec2(417, 650),
    [5] = vec2(494, 650),
    [6] = vec2(578, 650),
    [7] = vec2(659, 650),
}

function DrawBackground()
    display.image({
        image = "assets/INT_SCREEN_G.png",
        pos = vec2(0, 0),
        size = vec2(1024,1024),
        uvStart = vec2(0, 0),
        uvEnd = vec2(1, 1),
    })
end

function DrawGearBackground(pos)
    display.image({
        image = "assets/INT_SCREEN_G.png",
        pos = pos,
        size = vec2(109,124),
        uvStart = vec2(30/1024, 900/1024),
        uvEnd = vec2(140/1024, 1024/1024),
    })
end

function DrawSpeed()
    display.text({
        text = math.floor(car.speedKmh),
        pos = vec2(276, 251),
        letter = vec2(200,300),
        font = "amg",
        color = rgbm.colors.white,
        alignment = 0.5,
        spacing = -70,
        width = 460
    })
end

function DrawTime()
    display.text({
        text = string.format("%02d:%02d", sim.timeHours, sim.timeMinutes),
        pos = vec2(340, 760),
        letter = vec2(70,92),
        font = "amg2",
        color = rgbm.colors.white,
        alignment = 1,
        spacing = -32,
        width = 300
    })
end

function DrawTemp()
    display.text({
        text = string.format("%.1f", sim.ambientTemperature),
        pos = vec2(270, 845),
        letter = vec2(70,92),
        font = "amg2",
        color = rgbm.colors.white,
        alignment = 1,
        spacing = -32,
        width = 300
    })
end


function script.update(dt)
    DrawGearBackground(gearposmap[car.gear])
    DrawBackground()
    DrawSpeed()
    DrawTime()
    DrawTemp()
end