local ini = ac.INIConfig.carData(0, 'car.ini')
local fuelConsumption = ini:get("FUEL", "CONSUMPTION", 0)


function DrawBackground()
    display.image({
        image = "DISCD.png",
        pos = vec2(0,0),
        size = vec2(1280,520),
        uvStart = vec2(0,0),
        uvEnd = vec2(1, 1)
    })
end

function DrawCurrentSong()
    local song = ac.currentlyPlaying()
    local songText = song.title:gsub(" ", "_")
    if string.len(songText) > 15 then
        songText = string.sub(songText, 1, 15)
    end
    local minutes = math.floor(song.trackPosition / 60)
    local remainingSeconds = song.trackPosition % 60
    if song.title == '' then
        display.text({
            text = "sound_of_silence.mp3",
            pos = vec2(100,247),
            letter = vec2(35,55),
            font = 'verdana',
            color = rgbm.colors.white,
            alignment = 0,
            width = 10,
            spacing = -10
        })
        display.text({
            text = "-- --",
            pos = vec2(635,247),
            letter = vec2(35,55),
            font = 'verdana',
            color = rgbm.colors.white,
            alignment = 0,
            width = 10,
            spacing = -15
        })
    else
        display.text({
            text = string.format('%s.mp3',songText),
            pos = vec2(100,247),
            letter = vec2(35,55),
            font = 'verdana',
            color = rgbm.colors.white,
            alignment = 0,
            width = 10,
            spacing = -10
        })
        display.text({
            text = string.format("%02d %02d", minutes, remainingSeconds),
            pos = vec2(635,247),
            letter = vec2(35,55),
            font = 'verdana',
            color = rgbm.colors.white,
            alignment = 0,
            width = 10,
            spacing = -15
        })
    end
end

local carFuel = car.fuel -- fuel entered in tank since pit
local currentLitersAvailable = car.fuel -- fuel available in tank since pit
local litersUsed = 0 -- fuel used in tank since pit
local distanceTravelledKm = 0 -- distance travelled in a second
local currentRange = car.fuel * 10
local litersUsed = 0
local litersPer100 = 0

function DrawRange()
    distanceTravelledKm = car.distanceDrivenSessionKm
    setTimeout(function ()
        carFuel = car.fuel
        litersUsed = litersUsed + (car.rpm * car.gas * fuelConsumption)/1000 --Fuel consumption. In one second the consumption is (rpm*gas*CONSUMPTION)/1000 litres
        
        if car.distanceDrivenSessionKm-distanceTravelledKm > 0 then
            litersPer100 = ((car.rpm * car.gas * fuelConsumption)/1000)/((car.distanceDrivenSessionKm-distanceTravelledKm) * 3)
        else
            litersPer100 = (car.rpm * car.gas * fuelConsumption)*4
        end
        currentRange = math.max(0, (car.fuel- ((car.rpm * car.gas * fuelConsumption)/1000)) * 700 / 70)
    end, 1, "0")
    if math.abs(car.fuel - carFuel) > 2 then -- hacky way to figure if the user changed fuel in the setup menu
        currentLitersAvailable = car.fuel
        litersUsed = 0
    end
    display.text({
        text = math.floor(currentRange),
        pos = vec2(825,165),
        letter = vec2(35,55),
        font = 'verdana',
        color = rgbm.colors.white,
        alignment = 0.5,
        width = 120,
        spacing = -15
    })

    if litersPer100 ~= nil  then
        display.text({
            text =  string.format("%.1f", litersPer100),
            pos = vec2(825,338),
            letter = vec2(35,55),
            font = 'verdana',
            color = rgbm.colors.white,
            alignment = 0.5,
            width = 120,
            spacing = -15
        })
    end
end

function DrawSpeed()
    display.text({
        text = math.floor(car.speedKmh),
        pos = vec2(825,283),
        letter = vec2(35,55),
        font = 'verdana',
        color = rgbm.colors.white,
        alignment = 0.5,
        width = 120,
        spacing = -15
    })
end

function DrawDates()
    display.text({
        text = string.format("%02d %02d", sim.timeHours, sim.timeMinutes),
        pos = vec2(657,425),
        letter = vec2(35,50),
        font = 'verdana',
        color = rgbm.colors.white,
        alignment = 0.5,
        width = 120,
        spacing = -15
    })
    display.text({
        text = os.date("%d %m %y"),
        pos = vec2(1060,425),
        letter = vec2(35,50),
        font = 'verdana',
        color = rgbm.colors.white,
        alignment = 0.5,
        width = 120,
        spacing = -15
    })
end

function script.update(dt)
    DrawBackground()
    DrawCurrentSong()
    DrawRange()
    DrawSpeed()
    DrawDates()
end